/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class VWAttributeInfo
implements Serializable {
    private static final long serialVersionUID = 7448L;
    protected Hashtable attributes = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-28 20:25:42 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/3 $";
    }

    public VWAttributeInfo() throws VWException {
    }

    protected VWAttributeInfo(Hashtable theAttributes) {
        this.attributes = theAttributes;
    }

    public void setFieldValue(String fieldName, Object fieldValue) throws VWException {
        Object rObj = null;
        int typeNew = VWFieldType.getVWFieldType(fieldValue);
        if (fieldValue != null && (0x21F & typeNew) != typeNew) {
            throw new VWException("vw.api.VWAttributeInfoInvalidFieldType", "Invalid field type {0}. Attribute field value should be of a basic field type.", new Integer(typeNew));
        }
        if (fieldValue != null && fieldValue.getClass().isArray()) {
            int len = ((Object[])fieldValue).length;
            if (len == 0) {
                throw new VWException("vw.api.VWAttributeInfoArrayZeroLength", "Invalid attribute array value. Array value must have a length greater than zero.");
            }
            for (int i = 0; i < len; ++i) {
                if (((Object[])fieldValue)[i] != null) continue;
                throw new VWException("vw.api.VWAttributeInfoArrayValueContainsNull", "Invalid attribute array value. Array value cannot contain null elements.");
            }
        }
        if (fieldName != null) {
            if (this.attributes != null && this.attributes.containsKey(fieldName)) {
                rObj = this.attributes.get(fieldName);
                if (rObj != null && fieldValue != null) {
                    int typeOriginal = VWFieldType.getVWFieldType(rObj);
                    if (typeOriginal != typeNew) {
                        throw new VWException("vw.api.VWAttributeInfoSetFieldValueBadValueType", "Field value {0} should be of type {1}", fieldValue, new Integer(typeOriginal));
                    }
                } else if (fieldValue == null) {
                    this.attributes.remove(fieldName);
                    return;
                }
            }
            if (this.attributes == null) {
                this.attributes = new Hashtable(1);
            }
            if (fieldValue != null) {
                this.attributes.put(fieldName, fieldValue);
            }
        } else {
            throw new VWException("vw.api.VWAttributeInfoNullFieldName", "Field name can not be null.");
        }
    }

    public Object getFieldValue(String fieldName) throws VWException {
        Object result = null;
        if (fieldName != null) {
            if (this.attributes != null && this.attributes.containsKey(fieldName)) {
                result = this.attributes.get(fieldName);
            }
        } else {
            throw new VWException("vw.api.VWAttributeInfoNullFieldName", "Field name can not be null.");
        }
        return result;
    }

    public int getFieldType(String fieldName) throws VWException {
        return VWFieldType.getVWFieldType(this.getFieldValue(fieldName));
    }

    public boolean isFieldArray(String fieldName) throws VWException {
        boolean result = false;
        Object rObj = null;
        rObj = this.getFieldValue(fieldName);
        if (rObj != null && rObj instanceof Object[]) {
            result = true;
        }
        return result;
    }

    public void deleteField(String fieldName) throws VWException {
        if (fieldName != null) {
            this.setFieldValue(fieldName, null);
        }
    }

    public String[] getAttributeNames() throws VWException {
        return VWAttributeInfo.getAttributeNames(this.attributes);
    }

    protected static String[] getAttributeNames(Hashtable theAttributes) throws VWException {
        String[] result = null;
        if (theAttributes != null) {
            Enumeration theKeys = theAttributes.keys();
            String aKey = null;
            Object aValue = null;
            result = new String[theAttributes.size()];
            for (int i = 0; i < theAttributes.size(); ++i) {
                if (!theKeys.hasMoreElements()) continue;
                result[i] = aKey = (String)theKeys.nextElement();
            }
        }
        return result;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAttributeInfoNullBuffer", "buffer parameter cannot be null.");
        }
        if (this.attributes == null || this.attributes.size() == 0) {
            return;
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        String INDENT_3 = INDENT_2 + "\t";
        theBuffer.append(INDENT_0 + "<" + "ModelAttributes" + ">\n");
        Enumeration theKeys = this.attributes.keys();
        while (theKeys.hasMoreElements()) {
            String nextKey = (String)theKeys.nextElement();
            Object nextValue = this.attributes.get(nextKey);
            theBuffer.append(INDENT_1 + "<" + "ModelAttribute" + "\n");
            theBuffer.append(INDENT_2 + "Name" + "=\"" + VWXMLHandler.toXMLString(nextKey) + "\"\n");
            theBuffer.append(INDENT_2 + "Type" + "=\"" + VWFieldType.typeToString(this.getFieldType(nextKey)) + "\"\n");
            theBuffer.append(INDENT_2 + "IsArray" + "=\"" + VWXMLHandler.booleanToString(this.isFieldArray(nextKey)) + "\">");
            if (!this.isFieldArray(nextKey)) {
                if (nextValue instanceof Date) {
                    theBuffer.append("\n" + INDENT_3 + "<" + "Value" + " Val=\"" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)nextValue)) + "\"/>");
                } else {
                    theBuffer.append("\n" + INDENT_3 + "<" + "Value" + " Val=\"" + VWXMLHandler.toXMLString(nextValue.toString()) + "\"/>");
                }
            } else {
                int arrayCount = ((Object[])nextValue).length;
                for (int i = 0; i < arrayCount; ++i) {
                    if (((Object[])nextValue)[i] instanceof Date) {
                        theBuffer.append("\n" + INDENT_3 + "<" + "Value" + " Val=\"" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)((Object[])nextValue)[i])) + "\"/>");
                        continue;
                    }
                    theBuffer.append("\n" + INDENT_3 + "<" + "Value" + " Val=\"" + VWXMLHandler.toXMLString(((Object[])nextValue)[i].toString()) + "\"/>");
                }
            }
            theBuffer.append("\n" + INDENT_1 + "</" + "ModelAttribute" + ">\n");
        }
        theBuffer.append(INDENT_0 + "</" + "ModelAttributes" + ">\n");
    }
}

